/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.Optional;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IItemEmcHolder;
import moze_intel.projecte.gameObjs.EnumCollectorTier;
import moze_intel.projecte.gameObjs.block_entities.CollectorMK1BlockEntity;
import moze_intel.projecte.gameObjs.blocks.BlockDirection;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.MathUtils;
import moze_intel.projecte.utils.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Collector
extends BlockDirection
implements PEEntityBlock<CollectorMK1BlockEntity> {
    private final EnumCollectorTier tier;

    public Collector(EnumCollectorTier tier, BlockBehaviour.Properties props) {
        super(props);
        this.tier = tier;
    }

    public EnumCollectorTier getTier() {
        return this.tier;
    }

    @Deprecated
    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        CollectorMK1BlockEntity collector;
        if (!level.f_46443_ && (collector = WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos, true)) != null) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)collector, (BlockPos)pos);
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    @Nullable
    public MenuProvider m_7246_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        return WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos, true);
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<? extends CollectorMK1BlockEntity> getType() {
        return switch (this.tier) {
            default -> throw new IncompatibleClassChangeError();
            case EnumCollectorTier.MK1 -> PEBlockEntityTypes.COLLECTOR;
            case EnumCollectorTier.MK2 -> PEBlockEntityTypes.COLLECTOR_MK2;
            case EnumCollectorTier.MK3 -> PEBlockEntityTypes.COLLECTOR_MK3;
        };
    }

    @Deprecated
    public boolean m_8133_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int id, int param) {
        super.m_8133_(state, level, pos, id, param);
        return this.triggerBlockEntityEvent(state, level, pos, id, param);
    }

    @Deprecated
    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int m_6782_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        CollectorMK1BlockEntity collector = WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos, true);
        if (collector == null) {
            return super.m_6782_(state, level, pos);
        }
        Optional cap = collector.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, Direction.UP).resolve();
        if (cap.isEmpty()) {
            return super.m_6782_(state, level, pos);
        }
        ItemStack charging = ((IItemHandler)cap.get()).getStackInSlot(0);
        if (!charging.m_41619_()) {
            Optional holderCapability = charging.getCapability(PECapabilities.EMC_HOLDER_ITEM_CAPABILITY).resolve();
            if (holderCapability.isPresent()) {
                IItemEmcHolder emcHolder = (IItemEmcHolder)holderCapability.get();
                return MathUtils.scaleToRedstone(emcHolder.getStoredEmc(charging), emcHolder.getMaximumEmc(charging));
            }
            return MathUtils.scaleToRedstone(collector.getStoredEmc(), collector.getEmcToNextGoal());
        }
        return MathUtils.scaleToRedstone(collector.getStoredEmc(), collector.getMaximumEmc());
    }

    @Override
    @Deprecated
    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            CollectorMK1BlockEntity ent = WorldHelper.getBlockEntity(CollectorMK1BlockEntity.class, (BlockGetter)level, pos);
            if (ent != null) {
                ent.clearLocked();
            }
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }
}

